% created by Nils Hase 2016 (nilshase@math.uni-bremen.de)

% function to give output to a flux estimate f_opt of dimensions 1469x1 and
% plot the estimate in a US map

function [rel_error,abs_budget_error] = show_result(methodname,f_opt,f_EDGAR,alpha_opt,runtime)

load('synthetic_methane_data','area')

if isempty(alpha_opt);
    alpha_opt = '-';
end
if nargin < 5
    runtime = '-';
end
if nargin < 4
    alpha_opt = '-';
end

% Calculate metrics for method comparison 
rel_error = norm((f_EDGAR-f_opt).*area)/norm(f_EDGAR.*area);
sol_budget = sum(f_EDGAR.*area);
abs_budget_error = abs(sol_budget - sum(f_opt.*area)); 
sol_budget = sum(f_EDGAR.*area);

% Print results to command line
fprintf([methodname,'\n   rel. error (2-norm): ',num2str(rel_error), ...
        '\n   abs. error of total / total: ',num2str(abs_budget_error),' / ',num2str(sol_budget), ...
        '\n   chosen regularization parameter: ',num2str(alpha_opt), ...
        '\n   runtime: ',num2str(runtime),' sec.\n\n'])
 
% Plot result
map_result(f_opt,[methodname,', rel. error: ',num2str(rel_error)]);

end
